<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Etapa;
use App\Models\Op;
use App\Models\Oficina;

class DashboardController extends Controller
{
    public function index(Request $request)
    {
        $query = Etapa::with(['op','oficina'])->orderBy('data_inicio');

        // Filtro por status
        if ($request->filled('status') && $request->status != 'Todos') {
            $query->where('status', $request->status);
        }

        // Filtro por oficina
        if ($request->filled('oficina_id')) {
            $query->where('oficina_id', $request->oficina_id);
        }

        // Filtro por numero_op
        if ($request->filled('numero_op')) {
            $query->whereHas('op', function($q) use ($request) {
                $q->where('numero_op', $request->numero_op);
            });
        }

        $etapas = $query->get();
        $oficinas = Oficina::all();

        return view('dashboard', compact('etapas','oficinas'));
    }
}
