<?php

namespace App\Http\Controllers;

use App\Models\Modelo;
use Illuminate\Http\Request;

class ModeloController extends Controller
{
    public function index()
    {
        $modelos = Modelo::all();
        return view('modelos.index', compact('modelos'));
    }

    public function create()
    {
        return view('modelos.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'nome' => 'required',
            'tamanho' => 'nullable',
            'ficha_tecnica' => 'nullable',
        ]);

        Modelo::create($request->all());

        return redirect()->route('modelos.index')
            ->with('success', 'Modelo criado com sucesso.');
    }

    public function show(Modelo $modelo)
    {
        return view('modelos.show', compact('modelo'));
    }

    public function edit(Modelo $modelo)
    {
        return view('modelos.edit', compact('modelo'));
    }

    public function update(Request $request, Modelo $modelo)
    {
        $request->validate([
            'nome' => 'required',
            'tamanho' => 'nullable',
            'ficha_tecnica' => 'nullable',
        ]);

        $modelo->update($request->all());

        return redirect()->route('modelos.index')
            ->with('success', 'Modelo atualizado com sucesso.');
    }

    public function destroy(Modelo $modelo)
    {
        $modelo->delete();

        return redirect()->route('modelos.index')
            ->with('success', 'Modelo excluído com sucesso.');
    }
}
