<?php

namespace App\Http\Controllers;

use App\Models\Oficina;
use Illuminate\Http\Request;

class OficinaController extends Controller
{
    public function index()
    {
        $oficinas = Oficina::all();
        return view('oficinas.index', compact('oficinas'));
    }

    public function create()
    {
        return view('oficinas.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'nome' => 'required',
            'tipo' => 'required|in:Corte,Costura,Lavanderia,Bordado',
            'endereco' => 'nullable',
            'responsavel' => 'nullable',
        ]);

        Oficina::create($request->all());

        return redirect()->route('oficinas.index')
            ->with('success', 'Oficina criada com sucesso.');
    }

    public function show(Oficina $oficina)
    {
        return view('oficinas.show', compact('oficina'));
    }

    public function edit(Oficina $oficina)
    {
        return view('oficinas.edit', compact('oficina'));
    }

    public function update(Request $request, Oficina $oficina)
    {
        $request->validate([
            'nome' => 'required',
            'tipo' => 'required|in:Corte,Costura,Lavanderia,Bordado',
            'endereco' => 'nullable',
            'responsavel' => 'nullable',
        ]);

        $oficina->update($request->all());

        return redirect()->route('oficinas.index')
            ->with('success', 'Oficina atualizada com sucesso.');
    }

    public function destroy(Oficina $oficina)
    {
        $oficina->delete();

        return redirect()->route('oficinas.index')
            ->with('success', 'Oficina excluída com sucesso.');
    }
}
