<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Etapa extends Model
{
    use HasFactory;

    protected $fillable = [
        'op_id',
        'oficina_id',
        'etapa',
        'status',
        'data_inicio',
        'data_conclusao',
        'data_previsao',
        'comprovante',
    ];

    public function op()
    {
        return $this->belongsTo(Op::class);
    }
    public function logs()
    {
    return $this->hasMany(EtapaLog::class);
    }


    public function oficina()
    {
        return $this->belongsTo(Oficina::class);
    }
    public function getStatusAttribute($value)
{
    if ($value !== 'Concluido' && $this->data_previsao && now()->gt(\Carbon\Carbon::parse($this->data_previsao))) {
        return 'Pendente';
    }
    return $value;
}

}
