<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EtapaLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'etapa_id',
        'campo_alterado',
        'valor_anterior',
        'valor_novo',
        'usuario',
        'data'
    ];

    protected $casts = [
        'data' => 'datetime',
    ];

    public function etapa()
    {
        return $this->belongsTo(Etapa::class);
    }
}
