<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Material extends Model
{
    protected $table = 'materiais'; // <==== aqui define a tabela certa
    protected $fillable = [
        'nome',
        'unidade',
        'estoque_atual',
        'estoque_minimo',
        'categoria',
    ];

    public function movimentacoes()
    {
        return $this->hasMany(MovimentacaoEstoque::class);
    }

    public function consumos()
    {
        return $this->hasMany(ConsumoOp::class);
    }

    // Método para obter histórico completo
    public function getHistoricoCompleto()
    {
        $historico = collect();

        // Adicionar movimentações de estoque
        foreach ($this->movimentacoes()->orderBy('data', 'desc')->get() as $mov) {
            $historico->push([
                'tipo' => $mov->tipo == 'entrada' ? 'Entrada' : 'Saída',
                'quantidade' => $mov->quantidade,
                'motivo' => $mov->motivo,
                'data' => $mov->data,
                'categoria' => 'movimentacao'
            ]);
        }

        // Adicionar consumos por OP
        foreach ($this->consumos()->with('op')->orderBy('created_at', 'desc')->get() as $consumo) {
            $historico->push([
                'tipo' => 'Consumo OP',
                'quantidade' => $consumo->quantidade,
                'motivo' => 'OP: ' . ($consumo->op->numero_op ?? 'N/A'),
                'data' => $consumo->created_at,
                'categoria' => 'consumo'
            ]);
        }

        return $historico->sortByDesc('data');
    }
}
