<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MovimentacaoEstoque extends Model
{
    use HasFactory;

    protected $table = 'movimentacoes_estoque';

    protected $fillable = [
        'material_id',
        'tipo',
        'quantidade',
        'motivo',
        'data',
    ];

    protected $casts = [
        'data' => 'datetime',
    ];

    public function material()
    {
        return $this->belongsTo(Material::class);
    }
}
