<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Op extends Model
{
    use HasFactory;

    protected $fillable = [
        'numero_op',
        'data',
        'descricao',
        'quantidade',
        'modelo_id',
        'ziper_necessario',
        'tecido_necessario',
        'forro_necessario',
    ];

    public function modelo()
    {
        return $this->belongsTo(Modelo::class);
    }

    public function etapas()
    {
        return $this->hasMany(Etapa::class);
    }
    public function consumos()
{
    return $this->hasMany(\App\Models\ConsumoOp::class, 'op_id');
}

}
// This model represents the "Op" (Order of Production) entity in the system.