<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tecidos', function (Blueprint $table) {
        $table->id();
        $table->string('tipo');
        $table->decimal('metragem', 8, 2);
        $table->date('data_compra')->nullable();
        $table->decimal('preco', 10, 2)->nullable();
        $table->foreignId('fornecedor_id')->constrained('fornecedores')->onDelete('cascade');
        $table->timestamps();
    });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tecidos');
    }
};
