<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ops', function (Blueprint $table) {
        $table->id();
        $table->string('numero_op')->unique();
        $table->date('data')->nullable();
        $table->string('descricao')->nullable();
        $table->integer('quantidade')->default(0);
        $table->foreignId('modelo_id')->constrained('modelos')->onDelete('cascade');
        $table->timestamps();
    });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ops');
    }
};
