<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
         Schema::create('etapas', function (Blueprint $table) {
        $table->id();
        $table->foreignId('op_id')->constrained('ops')->onDelete('cascade');
        $table->foreignId('oficina_id')->constrained('oficinas')->onDelete('cascade');
        $table->enum('etapa', ['Compra do Tecido', 'Envio para Sao Paulo', 'Corte', 'Costura', 'Lavanderia']);
        $table->enum('status', ['Pendente', 'Em Andamento', 'Concluido'])->default('Pendente');
        $table->date('data_inicio')->nullable();
        $table->date('data_conclusao')->nullable();
        $table->string('comprovante')->nullable(); // caminho do arquivo
        $table->timestamps();
    });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('etapas');
    }
};
