<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
{
    Schema::create('movimentacoes_estoque', function (Blueprint $table) {
        $table->id();
        $table->foreignId('material_id')->constrained('materiais')->cascadeOnDelete();
        $table->enum('tipo', ['entrada', 'saida']);
        $table->decimal('quantidade', 10, 2);
        $table->string('motivo')->nullable(); // ex.: "Ordem de Produção #003"
        $table->datetime('data');
        $table->timestamps();
    });
}

public function down()
{
    Schema::dropIfExists('movimentacoes_estoque');
}

};
