<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
{
    Schema::create('consumos_op', function (Blueprint $table) {
        $table->id();
        $table->foreignId('op_id')->constrained('ops')->cascadeOnDelete();
        $table->foreignId('material_id')->constrained('materiais')->cascadeOnDelete();
        $table->decimal('quantidade', 10,2);
        $table->string('unidade')->nullable();
        $table->string('categoria')->nullable();
        $table->timestamps();
    });
}

public function down()
{
    Schema::dropIfExists('consumos_op');
}

};
