@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <h1 class="mb-4">Editar Consumo</h1>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('consumos.update', $consumo->id) }}" method="POST" class="card card-body">
        @csrf
        @method('PUT')

        <div class="mb-3">
            <label class="form-label">Ordem de Produção</label>
            <select name="op_id" class="form-select" required>
                <option value="">Selecione</option>
                @foreach($ops as $o)
                    <option value="{{ $o->id }}" @if($o->id == $consumo->op_id) selected @endif>
                        {{ $o->numero_op }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Material</label>
            <select name="material_id" class="form-select" required>
                <option value="">Selecione</option>
                @foreach($materiais as $m)
                    <option value="{{ $m->id }}" @if($m->id == $consumo->material_id) selected @endif>
                        {{ $m->nome }} ({{ $m->categoria }})
                    </option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Quantidade</label>
            <input type="number" step="0.01" name="quantidade" value="{{ old('quantidade', $consumo->quantidade) }}" class="form-control" required>
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">Atualizar</button>
            <a href="{{ route('consumos.index') }}" class="btn btn-secondary">Voltar</a>
        </div>
    </form>
</div>
@endsection
