@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <h1 class="mb-4">Consumos de Materiais</h1>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <a href="{{ route('consumos.create') }}" class="btn btn-primary mb-3">Registrar Consumo</a>

    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>ID</th>
                <th>OP</th>
                <th>Material</th>
                <th>Categoria</th>
                <th>Quantidade</th>
                <th>Unidade</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            @foreach($consumos as $c)
            <tr>
                <td>{{ $c->id }}</td>
                <td>{{ optional($c->op)->numero_op ?? '-' }}</td>
                <td>{{ optional($c->material)->nome ?? '-' }}</td>
                <td>{{ $c->categoria }}</td>
                <td>{{ $c->quantidade }}</td>
                <td>{{ $c->unidade }}</td>
                <td>
                    <a href="{{ route('consumos.show', $c) }}" class="btn btn-info btn-sm">Ver</a>
                    <a href="{{ route('consumos.edit', $c) }}" class="btn btn-warning btn-sm">Editar</a>
                    <form action="{{ route('consumos.destroy', $c) }}" method="POST" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button onclick="return confirm('Tem certeza?')" class="btn btn-danger btn-sm">Excluir</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
