@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <h1 class="mb-4">Detalhes do Consumo</h1>

    <div class="card card-body mb-3">
        <p><strong>Ordem de Produção:</strong> {{ optional($consumo->op)->numero_op ?? '-' }}</p>
        <p><strong>Material:</strong> {{ optional($consumo->material)->nome ?? '-' }}</p>
        <p><strong>Categoria:</strong> {{ $consumo->categoria }}</p>
        <p><strong>Quantidade:</strong> {{ $consumo->quantidade }}</p>
        <p><strong>Unidade:</strong> {{ $consumo->unidade }}</p>
        <p><strong>Cadastrado em:</strong> {{ $consumo->created_at }}</p>
    </div>
<h4>Histórico de Alterações</h4>
<ul>
@foreach($etapa->logs as $log)
    <li>
        {{ \Carbon\Carbon::parse($log->data)->format('d/m/Y H:i') }} -
        {{ $log->usuario }} mudou status para
        <strong>{{ $log->status }}</strong>
    </li>
@endforeach
</ul>

    <a href="{{ route('consumos.index') }}" class="btn btn-secondary">Voltar</a>
@endsection
