@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <h1 class="mb-4">Nova Etapa</h1>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('etapas.store') }}" method="POST" class="card card-body">
        @csrf

        <div class="mb-3">
            <label class="form-label">OP</label>
            <select name="op_id" class="form-select" required>
                <option value="">Selecione</option>
                @foreach(\App\Models\Op::all() as $o)
                    <option value="{{ $o->id }}">{{ $o->numero_op }}</option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Oficina</label>
            <select name="oficina_id" class="form-select" required>
                <option value="">Selecione</option>
                @foreach(\App\Models\Oficina::all() as $f)
                    <option value="{{ $f->id }}">{{ $f->nome }}</option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Etapa</label>
            <select name="etapa" class="form-select" required>
                <option value="">Selecione</option>
                <option value="Compra do Tecido">Compra do Tecido</option>
                <option value="Envio para São Paulo">Envio para São Paulo</option>
                <option value="Corte">Corte</option>
                <option value="Costura">Costura</option>
                <option value="Lavanderia">Lavanderia</option>
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Status</label>
            <select name="status" class="form-select" required>
                <option value="Pendente">Pendente</option>
                <option value="Em Andamento">Em Andamento</option>
                <option value="Concluido">Concluído</option>
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Data Início</label>
            <input type="date" name="data_inicio" class="form-control">
        </div>

        <div class="mb-3">
            <label class="form-label">Previsão</label>
            <input type="date" name="data_previsao" class="form-control">
        </div>

        <div class="mb-3">
            <label class="form-label">Data Conclusão</label>
            <input type="date" name="data_conclusao" class="form-control">
        </div>

        

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-success">Salvar</button>
            <a href="{{ route('etapas.index') }}" class="btn btn-secondary">Voltar</a>
        </div>
    </form>
</div>
@endsection
