@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <h1 class="mb-4">Editar Etapa</h1>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('etapas.update', $etapa->id) }}" method="POST" class="card card-body">
        @csrf
        @method('PUT')

        <div class="mb-3">
            <label class="form-label">OP</label>
            <select name="op_id" class="form-select" required>
                <option value="">Selecione</option>
                @foreach(\App\Models\Op::all() as $o)
                    <option value="{{ $o->id }}" @if($o->id == $etapa->op_id) selected @endif>{{ $o->numero_op }}</option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Oficina</label>
            <select name="oficina_id" class="form-select" required>
                <option value="">Selecione</option>
                @foreach(\App\Models\Oficina::all() as $f)
                    <option value="{{ $f->id }}" @if($f->id == $etapa->oficina_id) selected @endif>{{ $f->nome }}</option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Etapa</label>
            <select name="etapa" class="form-select" required>
                @foreach(['Compra do Tecido','Envio para São Paulo','Corte','Costura','Lavanderia'] as $e)
                    <option value="{{ $e }}" @if($e == $etapa->etapa) selected @endif>{{ $e }}</option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Status</label>
            <select name="status" class="form-select" required>
                @foreach(['Pendente','Em Andamento','Concluido'] as $s)
                    <option value="{{ $s }}" @if($s == $etapa->status) selected @endif>{{ $s }}</option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Data Início</label>
            <input type="date" name="data_inicio" value="{{ old('data_inicio', $etapa->data_inicio) }}" class="form-control">
        </div>

        <div class="mb-3">
            <label class="form-label">Previsão</label>
            <input type="date" name="data_previsao" value="{{ old('data_previsao', $etapa->data_previsao) }}" class="form-control">
        </div>

        <div class="mb-3">
            <label class="form-label">Data Conclusão</label>
            <input type="date" name="data_conclusao" value="{{ old('data_conclusao', $etapa->data_conclusao) }}" class="form-control">
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">Atualizar</button>
            <a href="{{ route('etapas.index') }}" class="btn btn-secondary">Voltar</a>
        </div>
    </form>
</div>
@endsection
