@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <h1 class="mb-4">Etapas de Produção</h1>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <a href="{{ route('etapas.create') }}" class="btn btn-primary mb-3">Nova Etapa</a>

    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>ID</th>
                <th>OP</th>
                <th>Oficina</th>
                <th>Etapa</th>
                <th>Status</th>
                <th>Data Início</th>
                <th>Data Conclusão</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            @foreach($etapas as $e)
            <tr>
                <td>{{ $e->id }}</td>
                <td>{{ optional($e->op)->numero_op ?? '-' }}</td>
                <td>{{ optional($e->oficina)->nome ?? '-' }}</td>
                <td>{{ $e->etapa }}</td>
                <td>{{ $e->status }}</td>
                <td>{{ $e->data_inicio }}</td>
                <td>{{ $e->data_conclusao }}</td>
                <td>
                    <a href="{{ route('etapas.show', $e) }}" class="btn btn-info btn-sm">Ver</a>
                    <a href="{{ route('etapas.edit', $e) }}" class="btn btn-warning btn-sm">Editar</a>
                    <form action="{{ route('etapas.destroy', $e) }}" method="POST" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button onclick="return confirm('Tem certeza?')" class="btn btn-danger btn-sm">Excluir</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
