@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <h1 class="mb-4">Detalhes da Etapa</h1>

    <div class="card card-body mb-4">
        <div class="row">
            <div class="col-md-6">
                <p><strong>OP:</strong> {{ optional($etapa->op)->numero_op ?? '-' }}</p>
                <p><strong>Oficina:</strong> {{ optional($etapa->oficina)->nome ?? '-' }}</p>
                <p><strong>Etapa:</strong> {{ $etapa->etapa }}</p>
                <p><strong>Status:</strong> 
                    @php
                        $statusAtual = $etapa->status;
                        if($etapa->data_previsao && now()->gt(\Carbon\Carbon::parse($etapa->data_previsao)) && $etapa->status != 'Concluido'){
                            $statusAtual = 'Pendente';
                        }
                    @endphp
                    <span class="badge bg-{{ $statusAtual == 'Concluido' ? 'success' : ($statusAtual == 'Pendente' ? 'danger' : 'warning') }}">
                        {{ $statusAtual }}
                    </span>
                </p>
            </div>
            <div class="col-md-6">
                <p><strong>Data Início:</strong> {{ $etapa->data_inicio ? \Carbon\Carbon::parse($etapa->data_inicio)->format('d/m/Y') : '-' }}</p>
                <p><strong>Previsão:</strong> {{ $etapa->data_previsao ? \Carbon\Carbon::parse($etapa->data_previsao)->format('d/m/Y') : '-' }}</p>
                <p><strong>Data Conclusão:</strong> {{ $etapa->data_conclusao ? \Carbon\Carbon::parse($etapa->data_conclusao)->format('d/m/Y') : '-' }}</p>
                @if($etapa->data_inicio)
                    <p><strong>Dias na Etapa:</strong> {{ (int) \Carbon\Carbon::parse($etapa->data_inicio)->diffInDays(now()) }}</p>
                @endif
            </div>
        </div>
    </div>

    <!-- Histórico Detalhado de Alterações -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="fas fa-history"></i>
                Histórico Detalhado de Alterações
            </h5>
        </div>
        <div class="card-body">
            @if($etapa->logs->count() > 0)
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Data/Hora</th>
                                <th>Usuário</th>
                                <th>Campo Alterado</th>
                                <th>Valor Anterior</th>
                                <th>Valor Novo</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($etapa->logs->sortByDesc('data') as $log)
                                <tr>
                                    <td>{{ \Carbon\Carbon::parse($log->data)->format('d/m/Y H:i') }}</td>
                                    <td>
                                        <span class="badge bg-secondary">{{ $log->usuario }}</span>
                                    </td>
                                    <td>
                                        <strong>{{ $log->campo_alterado }}</strong>
                                    </td>
                                    <td>
                                        @if($log->valor_anterior)
                                            <span class="text-muted">{{ $log->valor_anterior }}</span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($log->valor_novo)
                                            <span class="text-success"><strong>{{ $log->valor_novo }}</strong></span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="alert alert-info">
                    <i class="fas fa-info-circle"></i>
                    Nenhuma alteração registrada para esta etapa.
                </div>
            @endif
        </div>
    </div>

    <div class="mt-4">
        <a href="{{ route('etapas.index') }}" class="btn btn-secondary">Voltar</a>
        <a href="{{ route('etapas.edit', $etapa->id) }}" class="btn btn-primary">Editar</a>
    </div>
</div>
@endsection
