@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <h1 class="mb-4">Novo Fornecedor</h1>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('fornecedores.store') }}" method="POST" class="card card-body">
        @csrf

        <div class="mb-3">
            <label class="form-label">Nome</label>
            <input type="text" name="nome" class="form-control" required>
        </div>

        <div class="mb-3">
            <label class="form-label">CNPJ</label>
            <input type="text" name="cnpj" class="form-control">
        </div>

        <div class="mb-3">
            <label class="form-label">Contato</label>
            <input type="text" name="contato" class="form-control">
        </div>

        <div class="mb-3">
            <label class="form-label">Condições de Pagamento</label>
            <input type="text" name="condicoes_pagamento" class="form-control">
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-success">Salvar</button>
            <a href="{{ route('fornecedores.index') }}" class="btn btn-secondary">Voltar</a>
        </div>
    </form>
</div>
@endsection
