@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <h1 class="mb-4">Fornecedores</h1>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <a href="{{ route('fornecedores.create') }}" class="btn btn-primary mb-3">Novo Fornecedor</a>

    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>ID</th>
                <th>Nome</th>
                <th>CNPJ</th>
                <th>Contato</th>
                <th>Condições</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            @foreach($fornecedores as $f)
            <tr>
                <td>{{ $f->id }}</td>
                <td>{{ $f->nome }}</td>
                <td>{{ $f->cnpj }}</td>
                <td>{{ $f->contato }}</td>
                <td>{{ $f->condicoes_pagamento }}</td>
                <td>
                    <a href="{{ route('fornecedores.show', $f) }}" class="btn btn-info btn-sm">Ver</a>
                    <a href="{{ route('fornecedores.edit', $f) }}" class="btn btn-warning btn-sm">Editar</a>
                    <form action="{{ route('fornecedores.destroy', $f) }}" method="POST" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button onclick="return confirm('Tem certeza?')" class="btn btn-danger btn-sm">Excluir</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
