<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ config('app.name', 'Sistema Produção') }}</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="bg-gray-100 text-gray-900">

    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
    <div class="container">
        <a class="navbar-brand fw-bold" href="/">Sistema Produção</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ms-auto">
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('fornecedores.index') }}">Fornecedores</a>
                </li>
               
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('oficinas.index') }}">Oficinas</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('modelos.index') }}">Modelos</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('ops.index') }}">OPs</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('etapas.index') }}">Etapas</a>
                </li>
                <li>
                    <a class="nav-link" href="{{ route('materiais.index') }}">Materiais</a>
                </li>
            </ul>
        </div>
    </div>
</nav>


    <main class="p-4">
        @yield('content')
    </main>
<script src="https://cdn.jsdelivr.net/npm/vue@2.6.14"></script>
<script>
if (document.getElementById('materiais-repeater')) {
    new Vue({
        el: '#materiais-repeater',
        data: {
            materiais: {!! json_encode(session('materiais_old', [[]])) !!}
        },
        methods: {
            addItem() {
                this.materiais.push({});
            },
            removeItem(index) {
                this.materiais.splice(index, 1);
            }
        }
    });
}
</script>


</body>
</html>
