@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <h1 class="mb-4">Novo Material</h1>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('materiais.store') }}" method="POST" class="card card-body">
        @csrf

        <div class="mb-3">
            <label class="form-label">Nome</label>
            <input type="text" name="nome" class="form-control" required>
        </div>
        <div class="mb-3">
            <label class="form-label">Categoria</label>
            <select name="categoria" class="form-select">
                <option value="Tecido">Tecido</option>
                <option value="Forro">Forro</option>
                <option value="Zíper">Zíper</option>
                <option value="Outro">Outro</option>
            </select>
        </div>
        <div class="mb-3">
            <label class="form-label">Unidade</label>
            <input type="text" name="unidade" class="form-control" placeholder="ex.: metro, peça" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Estoque Inicial</label>
            <input type="number" step="0.01" name="estoque_atual" class="form-control">
        </div>

        <div class="mb-3">
            <label class="form-label">Estoque Mínimo</label>
            <input type="number" step="0.01" name="estoque_minimo" class="form-control">
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-success">Salvar</button>
            <a href="{{ route('materiais.index') }}" class="btn btn-secondary">Voltar</a>
        </div>
    </form>
</div>
@endsection
