@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <h1 class="mb-4">Editar Material</h1>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('materiais.update', $material->id) }}" method="POST" class="card card-body">
    @csrf
    @method('PUT')

        <div class="mb-3">
            <label class="form-label">Nome</label>
            <input type="text" name="nome" value="{{ old('nome', $material->nome) }}" class="form-control" required>
        </div>
        <div class="mb-3">
        <label class="form-label">Categoria</label>
        <select name="categoria" class="form-select">
            @foreach(['Tecido','Forro','Zíper','Outro'] as $cat)
                <option value="{{ $cat }}" @if($cat == $material->categoria) selected @endif>{{ $cat }}</option>
            @endforeach
        </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Unidade</label>
            <input type="text" name="unidade" value="{{ old('unidade', $material->unidade) }}" class="form-control" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Estoque Atual</label>
            <input type="number" step="0.01" name="estoque_atual" value="{{ old('estoque_atual', $material->estoque_atual) }}" class="form-control">
        </div>

        <div class="mb-3">
            <label class="form-label">Estoque Mínimo</label>
            <input type="number" step="0.01" name="estoque_minimo" value="{{ old('estoque_minimo', $material->estoque_minimo) }}" class="form-control">
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">Atualizar</button>
            <a href="{{ route('materiais.index') }}" class="btn btn-secondary">Voltar</a>
        </div>
    </form>
</div>
@endsection
