@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <h1 class="mb-4">Materiais</h1>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <a href="{{ route('materiais.create') }}" class="btn btn-primary mb-3">Novo Material</a>

    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>ID</th>
                <th>Nome</th>
                <th>Categoria</th>
                <th>Unidade</th>
                <th>Estoque Atual</th>
                <th>Estoque Mínimo</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            @foreach($materiais as $m)
            <tr @if($m->estoque_minimo && $m->estoque_atual <= $m->estoque_minimo) class="table-danger" @endif>
                <td>{{ $m->id }}</td>
                <td>{{ $m->nome }}</td>
                <td>{{ $m->categoria }}</td>
                <td>{{ $m->unidade }}</td>
                <td>{{ $m->estoque_atual }}</td>
                <td>{{ $m->estoque_minimo ?? '-' }}</td>
                <td>
                    <a href="{{ route('materiais.show', $m) }}" class="btn btn-info btn-sm">Ver</a>
                    <a href="{{ route('materiais.edit', $m->id) }}" class="btn btn-warning btn-sm">Editar</a>
                    
                    <form action="{{ route('materiais.destroy', $m->id) }}" method="POST" class="d-inline">

                        @csrf
                        @method('DELETE')
                        <button onclick="return confirm('Tem certeza?')" class="btn btn-danger btn-sm">Excluir</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
