@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <h1 class="mb-4">Detalhes do Material</h1>

    <div class="card card-body mb-4">
        <div class="row">
            <div class="col-md-6">
                <p><strong>Nome:</strong> {{ $material->nome }}</p>
                <p><strong>Categoria:</strong> {{ $material->categoria ?? 'N/A' }}</p>
                <p><strong>Unidade:</strong> {{ $material->unidade }}</p>
            </div>
            <div class="col-md-6">
                <p><strong>Estoque Atual:</strong> 
                    <span class="badge bg-{{ $material->estoque_atual > 0 ? 'success' : 'danger' }}">
                        {{ $material->estoque_atual }}
                    </span>
                </p>
                <p><strong>Estoque Mínimo:</strong> {{ $material->estoque_minimo }}</p>
                <p><strong>Data de Cadastro:</strong> {{ $material->created_at->format('d/m/Y H:i') }}</p>
            </div>
        </div>
    </div>

    <!-- Histórico Completo -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Histórico Completo</h5>
        </div>
        <div class="card-body">
            @php
                $historico = $material->getHistoricoCompleto();
            @endphp

            @if($historico->count() > 0)
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Data/Hora</th>
                                <th>Tipo</th>
                                <th>Quantidade</th>
                                <th>Motivo</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($historico as $item)
                                <tr>
                                    <td>{{ \Carbon\Carbon::parse($item['data'])->format('d/m/Y H:i') }}</td>
                                    <td>
                                        @if($item['categoria'] == 'movimentacao')
                                            <span class="badge bg-{{ $item['tipo'] == 'Entrada' ? 'success' : 'warning' }}">
                                                {{ $item['tipo'] }}
                                            </span>
                                        @else
                                            <span class="badge bg-danger">{{ $item['tipo'] }}</span>
                                        @endif
                                    </td>
                                    <td>{{ $item['quantidade'] }}</td>
                                    <td>{{ $item['motivo'] }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="alert alert-info">
                    <i class="fas fa-info-circle"></i>
                    Nenhuma movimentação registrada para este material.
                </div>
            @endif
        </div>
    </div>

    <!-- Resumo de Movimentações -->
    <div class="row mt-4">
        <div class="col-md-4">
            <div class="card text-white bg-success">
                <div class="card-body">
                    <h6 class="card-title">Total de Entradas</h6>
                    <p class="fs-5">{{ $historico->where('categoria', 'movimentacao')->where('tipo', 'Entrada')->sum('quantidade') }}</p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-white bg-danger">
                <div class="card-body">
                    <h6 class="card-title">Total de Saídas</h6>
                    <p class="fs-5">{{ $historico->where('categoria', 'consumo')->sum('quantidade') + $historico->where('categoria', 'movimentacao')->where('tipo', 'Saída')->sum('quantidade') }}</p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-white bg-info">
                <div class="card-body">
                    <h6 class="card-title">Consumos por OP</h6>
                    <p class="fs-5">{{ $historico->where('categoria', 'consumo')->count() }}</p>
                </div>
            </div>
        </div>
    </div>

    <div class="mt-4">
        <a href="{{ route('materiais.index') }}" class="btn btn-secondary">Voltar</a>
        <a href="{{ route('materiais.edit', $material->id) }}" class="btn btn-primary">Editar</a>
    </div>
</div>
@endsection
