@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <h1 class="mb-4">Editar Modelo</h1>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('modelos.update', $modelo->id) }}" method="POST" class="card card-body">
        @csrf
        @method('PUT')

        <div class="mb-3">
            <label class="form-label">Nome</label>
            <input type="text" name="nome" value="{{ old('nome', $modelo->nome) }}" class="form-control" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Tamanho</label>
            <input type="text" name="tamanho" value="{{ old('tamanho', $modelo->tamanho) }}" class="form-control">
        </div>

        <div class="mb-3">
            <label class="form-label">Ficha Técnica</label>
            <textarea name="ficha_tecnica" class="form-control">{{ old('ficha_tecnica', $modelo->ficha_tecnica) }}</textarea>
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">Atualizar</button>
            <a href="{{ route('modelos.index') }}" class="btn btn-secondary">Voltar</a>
        </div>
    </form>
</div>
@endsection
