@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <h1 class="mb-4">Modelos</h1>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <a href="{{ route('modelos.create') }}" class="btn btn-primary mb-3">Novo Modelo</a>

    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>ID</th>
                <th>Nome</th>
                <th>Tamanho</th>
                <th>Ficha Técnica</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            @foreach($modelos as $m)
            <tr>
                <td>{{ $m->id }}</td>
                <td>{{ $m->nome }}</td>
                <td>{{ $m->tamanho }}</td>
                <td>{{ $m->ficha_tecnica }}</td>
                <td>
                    <a href="{{ route('modelos.show', $m) }}" class="btn btn-info btn-sm">Ver</a>
                    <a href="{{ route('modelos.edit', $m) }}" class="btn btn-warning btn-sm">Editar</a>
                    <form action="{{ route('modelos.destroy', $m) }}" method="POST" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button onclick="return confirm('Tem certeza?')" class="btn btn-danger btn-sm">Excluir</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
