@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <h1 class="mb-4">Editar Oficina</h1>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('oficinas.update', $oficina->id) }}" method="POST" class="card card-body">
        @csrf
        @method('PUT')

        <div class="mb-3">
            <label class="form-label">Nome</label>
            <input type="text" name="nome" value="{{ old('nome', $oficina->nome) }}" class="form-control" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Responsável</label>
            <input type="text" name="responsavel" value="{{ old('responsavel', $oficina->responsavel) }}" class="form-control">
        </div>
        <div class="mb-3">
            <label class="form-label">Tipo</label>
            <input type="text" name="tipo" value="{{ old('tipo', $oficina->tipo) }}" class="form-control">
        </div>

       

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">Atualizar</button>
            <a href="{{ route('oficinas.index') }}" class="btn btn-secondary">Voltar</a>
        </div>
    </form>
</div>
@endsection
