@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <h1 class="mb-4">Oficinas</h1>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <a href="{{ route('oficinas.create') }}" class="btn btn-primary mb-3">Nova Oficina</a>

    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>ID</th>
                <th>Nome</th>
                <th>Responsável</th>
                <th>Tipo</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            @foreach($oficinas as $o)
            <tr>
                <td>{{ $o->id }}</td>
                <td>{{ $o->nome }}</td>
                <td>{{ $o->responsavel }}</td>
                <td>{{ $o->tipo }}</td>
                <td>
                    <a href="{{ route('oficinas.show', $o) }}" class="btn btn-info btn-sm">Ver</a>
                    <a href="{{ route('oficinas.edit', $o) }}" class="btn btn-warning btn-sm">Editar</a>
                    <form action="{{ route('oficinas.destroy', $o) }}" method="POST" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button onclick="return confirm('Tem certeza?')" class="btn btn-danger btn-sm">Excluir</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
