@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <h1 class="mb-4">Nova Ordem de Produção</h1>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('ops.store') }}" method="POST" class="card card-body">
        @csrf

        <div class="mb-3">
            <label class="form-label">Número OP</label>
            <input type="text" name="numero_op" value="{{ $proximoNumero }}" class="form-control" readonly style="background-color: #f8f9fa;">
            <small class="form-text text-muted">
                <i class="fas fa-info-circle"></i>
                Número gerado automaticamente de forma sequencial. Não pode ser editado.
            </small>
        </div>

        <div class="mb-3">
            <label class="form-label">Data</label>
            <input type="date" name="data" value="{{ old('data') }}" class="form-control">
        </div>

        <div class="mb-3">
            <label class="form-label">Modelo</label>
            <select name="modelo_id" value="{{ old('modelo_id') }}" class="form-select">
                <option value="">Selecione</option>
                @foreach(\App\Models\Modelo::all() as $m)
                  <option value="{{ $m->id }}" @selected(old('modelo_id') == $m->id)>
    {{ $m->nome }}
</option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Quantidade</label>
            <input type="number" name="quantidade" value="{{ old('quantidade') }}" class="form-control">
        </div>

        <div class="mb-3">
            <label class="form-label">Descrição</label>
            <textarea name="descricao" class="form-control">{{ old('descricao') }}</textarea>
        </div>

        
<hr>
<h4>Materiais Consumidos</h4>
<div id="materiais-container">
    @php
        $materiaisOld = session('materiais_old', old('materiais', []));
        $materiaisDisponiveis = \App\Models\Material::where('estoque_atual', '>', 0)->get();
    @endphp
    
    @if(count($materiaisOld) > 0)
        @foreach($materiaisOld as $index => $material)
        <div class="row mb-2 material-row">
            <div class="col-md-6">
                <select name="materiais[{{ $index }}][material_id]" class="form-select" required>
                    <option value="">Selecione o material</option>
                    @foreach($materiaisDisponiveis as $m)
                        <option value="{{ $m->id }}" {{ isset($material['material_id']) && $material['material_id'] == $m->id ? 'selected' : '' }}>
                            {{ $m->nome }} ({{ $m->categoria }}) - Estoque: {{ $m->estoque_atual }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-4">
                <input name="materiais[{{ $index }}][quantidade]" type="number" step="0.01" class="form-control" 
                       placeholder="Quantidade" value="{{ $material['quantidade'] ?? '' }}" required>
            </div>
            <div class="col-md-2">
                <button type="button" class="btn btn-danger btn-remove-material">X</button>
            </div>
        </div>
        @endforeach
    @else
        <div class="row mb-2 material-row">
            <div class="col-md-6">
                <select name="materiais[0][material_id]" class="form-select" required>
                    <option value="">Selecione o material</option>
                    @foreach($materiaisDisponiveis as $m)
                        <option value="{{ $m->id }}">{{ $m->nome }} ({{ $m->categoria }}) - Estoque: {{ $m->estoque_atual }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-4">
                <input name="materiais[0][quantidade]" type="number" step="0.01" class="form-control" placeholder="Quantidade" required>
            </div>
            <div class="col-md-2">
                <button type="button" class="btn btn-danger btn-remove-material">X</button>
            </div>
        </div>
    @endif
    
    <button type="button" class="btn btn-secondary mt-2" id="btn-add-material">+ Adicionar Material</button>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    let materialIndex = {{ count($materiaisOld) > 0 ? count($materiaisOld) : 1 }};
    
    // Adicionar material
    document.getElementById('btn-add-material').addEventListener('click', function() {
        const container = document.getElementById('materiais-container');
        const newRow = document.createElement('div');
        newRow.className = 'row mb-2 material-row';
        newRow.innerHTML = `
            <div class="col-md-6">
                <select name="materiais[${materialIndex}][material_id]" class="form-select" required>
                    <option value="">Selecione o material</option>
                    @foreach($materiaisDisponiveis as $m)
                        <option value="{{ $m->id }}">{{ $m->nome }} ({{ $m->categoria }}) - Estoque: {{ $m->estoque_atual }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-4">
                <input name="materiais[${materialIndex}][quantidade]" type="number" step="0.01" class="form-control" placeholder="Quantidade" required>
            </div>
            <div class="col-md-2">
                <button type="button" class="btn btn-danger btn-remove-material">X</button>
            </div>
        `;
        container.insertBefore(newRow, document.getElementById('btn-add-material'));
        materialIndex++;
    });
    
    // Remover material
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('btn-remove-material')) {
            const rows = document.querySelectorAll('.material-row');
            if (rows.length > 1) {
                e.target.closest('.material-row').remove();
            }
        }
    });
});
</script>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-success">Salvar</button>
            <a href="{{ route('ops.index') }}" class="btn btn-secondary">Voltar</a>
        </div>
    </form>
</div>

@endsection
