@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <h1 class="mb-4">Editar Ordem de Produção</h1>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('ops.update', $op->id) }}" method="POST" class="card card-body">
        @csrf
        @method('PUT')

        <div class="mb-3">
            <label class="form-label">Número OP</label>
            <input type="text" value="{{ $op->numero_op }}" class="form-control" readonly style="background-color: #f8f9fa;">
            <small class="form-text text-muted">
                <i class="fas fa-lock"></i>
                O número da OP não pode ser alterado. Para modificar, edite diretamente no banco de dados.
            </small>
        </div>

        <div class="mb-3">
            <label class="form-label">Data</label>
            <input type="date" name="data" value="{{ old('data', $op->data) }}" class="form-control">
        </div>

        <div class="mb-3">
            <label class="form-label">Modelo</label>
            <select name="modelo_id" class="form-select">
                <option value="">Selecione</option>
                @foreach(\App\Models\Modelo::all() as $m)
                    <option value="{{ $m->id }}" @if($m->id == $op->modelo_id) selected @endif>{{ $m->nome }}</option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Quantidade</label>
            <input type="number" name="quantidade" value="{{ old('quantidade', $op->quantidade) }}" class="form-control">
        </div>

        <div class="mb-3">
            <label class="form-label">Descrição</label>
            <textarea name="descricao" class="form-control">{{ old('descricao', $op->descricao) }}</textarea>
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">Atualizar</button>
            <a href="{{ route('ops.index') }}" class="btn btn-secondary">Voltar</a>
        </div>
    </form>
</div>
@endsection
