@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <h1 class="mb-4">Ordens de Produção</h1>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <a href="{{ route('ops.create') }}" class="btn btn-primary mb-3">Nova OP</a>

    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>ID</th>
                <th>Número</th>
                <th>Data</th>
                <th>Modelo</th>
                <th>Quantidade</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            @foreach($ops as $op)
            <tr>
                <td>{{ $op->id }}</td>
                <td>{{ $op->numero_op }}</td>
                <td>{{ $op->data }}</td>
                <td>{{ optional($op->modelo)->nome }}</td>
                <td>{{ $op->quantidade }}</td>
                <td>
                    <a href="{{ route('ops.show', $op) }}" class="btn btn-info btn-sm">Ver</a>
                    <a href="{{ route('ops.edit', $op) }}" class="btn btn-warning btn-sm">Editar</a>
                    <form action="{{ route('ops.destroy', $op) }}" method="POST" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button onclick="return confirm('Tem certeza?')" class="btn btn-danger btn-sm">Excluir</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
