@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <h1 class="mb-4">Detalhes da Ordem de Produção</h1>

    <div class="card card-body mb-3">
        <p><strong>Número OP:</strong> {{ $op->numero_op }}</p>
        <p><strong>Data:</strong> {{ \Carbon\Carbon::parse($op->data)->format('d/m/Y') }}</p>
        <p><strong>Modelo:</strong> {{ optional($op->modelo)->nome ?? '-' }}</p>
        <p><strong>Quantidade:</strong> {{ $op->quantidade }}</p>
        <p><strong>Descrição:</strong> {{ $op->descricao }}</p>
    </div>

    <h4>Materiais Consumidos</h4>
    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>Material</th>
                <th>Categoria</th>
                <th>Quantidade</th>
                <th>Unidade</th>
            </tr>
        </thead>
        <tbody>
            @forelse($op->consumos as $c)
                <tr>
                    <td>{{ optional($c->material)->nome ?? '-' }}</td>
                    <td>{{ $c->categoria }}</td>
                    <td>{{ $c->quantidade }}</td>
                    <td>{{ $c->unidade }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="4" class="text-center">Nenhum consumo registrado.</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <a href="{{ route('ops.index') }}" class="btn btn-secondary mt-3">Voltar</a>
</div>
@endsection
