<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\FornecedorController;
use App\Http\Controllers\TecidoController;
use App\Http\Controllers\OficinaController;
use App\Http\Controllers\ModeloController;
use App\Http\Controllers\OpController;
use App\Http\Controllers\EtapaController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Illuminate\View\View;
use App\Http\Requests\ProfileUpdateRequest;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\MaterialController;
use App\Http\Controllers\ConsumoOpController;


Route::middleware(['auth'])->group(function(){
Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
// Rotas dos CRUDs
Route::resource('fornecedores', FornecedorController::class)->parameters([
    'fornecedores' => 'fornecedor'
]);

Route::resource('materiais', MaterialController::class)->parameters([
    'materiais' => 'material'
]);
Route::resource('oficinas', OficinaController::class);
Route::resource('modelos', ModeloController::class);
Route::resource('ops', OpController::class);
Route::resource('consumos', ConsumoOpController::class);
Route::resource('etapas', EtapaController::class);
});




Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
