

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h1 class="mb-4">Materiais</h1>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <a href="<?php echo e(route('materiais.create')); ?>" class="btn btn-primary mb-3">Novo Material</a>

    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>ID</th>
                <th>Nome</th>
                <th>Categoria</th>
                <th>Unidade</th>
                <th>Estoque Atual</th>
                <th>Estoque Mínimo</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $materiais; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr <?php if($m->estoque_minimo && $m->estoque_atual <= $m->estoque_minimo): ?> class="table-danger" <?php endif; ?>>
                <td><?php echo e($m->id); ?></td>
                <td><?php echo e($m->nome); ?></td>
                <td><?php echo e($m->categoria); ?></td>
                <td><?php echo e($m->unidade); ?></td>
                <td><?php echo e($m->estoque_atual); ?></td>
                <td><?php echo e($m->estoque_minimo ?? '-'); ?></td>
                <td>
                    <a href="<?php echo e(route('materiais.show', $m)); ?>" class="btn btn-info btn-sm">Ver</a>
                    <a href="<?php echo e(route('materiais.edit', $m->id)); ?>" class="btn btn-warning btn-sm">Editar</a>
                    
                    <form action="<?php echo e(route('materiais.destroy', $m->id)); ?>" method="POST" class="d-inline">

                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button onclick="return confirm('Tem certeza?')" class="btn btn-danger btn-sm">Excluir</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\sistema-producao\resources\views/materiais/index.blade.php ENDPATH**/ ?>