

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h1 class="mb-4">Nova Ordem de Produção</h1>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('ops.store')); ?>" method="POST" class="card card-body">
        <?php echo csrf_field(); ?>

        <div class="mb-3">
            <label class="form-label">Número OP</label>
            <input type="text" name="numero_op" value="<?php echo e($proximoNumero); ?>" class="form-control" readonly style="background-color: #f8f9fa;">
            <small class="form-text text-muted">
                <i class="fas fa-info-circle"></i>
                Número gerado automaticamente de forma sequencial. Não pode ser editado.
            </small>
        </div>

        <div class="mb-3">
            <label class="form-label">Data</label>
            <input type="date" name="data" value="<?php echo e(old('data')); ?>" class="form-control">
        </div>

        <div class="mb-3">
            <label class="form-label">Modelo</label>
            <select name="modelo_id" value="<?php echo e(old('modelo_id')); ?>" class="form-select">
                <option value="">Selecione</option>
                <?php $__currentLoopData = \App\Models\Modelo::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($m->id); ?>" <?php if(old('modelo_id') == $m->id): echo 'selected'; endif; ?>>
    <?php echo e($m->nome); ?>

</option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Quantidade</label>
            <input type="number" name="quantidade" value="<?php echo e(old('quantidade')); ?>" class="form-control">
        </div>

        <div class="mb-3">
            <label class="form-label">Descrição</label>
            <textarea name="descricao" class="form-control"><?php echo e(old('descricao')); ?></textarea>
        </div>

        
<hr>
<h4>Materiais Consumidos</h4>
<div id="materiais-container">
    <?php
        $materiaisOld = session('materiais_old', old('materiais', []));
        $materiaisDisponiveis = \App\Models\Material::where('estoque_atual', '>', 0)->get();
    ?>
    
    <?php if(count($materiaisOld) > 0): ?>
        <?php $__currentLoopData = $materiaisOld; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $material): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="row mb-2 material-row">
            <div class="col-md-6">
                <select name="materiais[<?php echo e($index); ?>][material_id]" class="form-select" required>
                    <option value="">Selecione o material</option>
                    <?php $__currentLoopData = $materiaisDisponiveis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($m->id); ?>" <?php echo e(isset($material['material_id']) && $material['material_id'] == $m->id ? 'selected' : ''); ?>>
                            <?php echo e($m->nome); ?> (<?php echo e($m->categoria); ?>) - Estoque: <?php echo e($m->estoque_atual); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-4">
                <input name="materiais[<?php echo e($index); ?>][quantidade]" type="number" step="0.01" class="form-control" 
                       placeholder="Quantidade" value="<?php echo e($material['quantidade'] ?? ''); ?>" required>
            </div>
            <div class="col-md-2">
                <button type="button" class="btn btn-danger btn-remove-material">X</button>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php else: ?>
        <div class="row mb-2 material-row">
            <div class="col-md-6">
                <select name="materiais[0][material_id]" class="form-select" required>
                    <option value="">Selecione o material</option>
                    <?php $__currentLoopData = $materiaisDisponiveis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($m->id); ?>"><?php echo e($m->nome); ?> (<?php echo e($m->categoria); ?>) - Estoque: <?php echo e($m->estoque_atual); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-4">
                <input name="materiais[0][quantidade]" type="number" step="0.01" class="form-control" placeholder="Quantidade" required>
            </div>
            <div class="col-md-2">
                <button type="button" class="btn btn-danger btn-remove-material">X</button>
            </div>
        </div>
    <?php endif; ?>
    
    <button type="button" class="btn btn-secondary mt-2" id="btn-add-material">+ Adicionar Material</button>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    let materialIndex = <?php echo e(count($materiaisOld) > 0 ? count($materiaisOld) : 1); ?>;
    
    // Adicionar material
    document.getElementById('btn-add-material').addEventListener('click', function() {
        const container = document.getElementById('materiais-container');
        const newRow = document.createElement('div');
        newRow.className = 'row mb-2 material-row';
        newRow.innerHTML = `
            <div class="col-md-6">
                <select name="materiais[${materialIndex}][material_id]" class="form-select" required>
                    <option value="">Selecione o material</option>
                    <?php $__currentLoopData = $materiaisDisponiveis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($m->id); ?>"><?php echo e($m->nome); ?> (<?php echo e($m->categoria); ?>) - Estoque: <?php echo e($m->estoque_atual); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-4">
                <input name="materiais[${materialIndex}][quantidade]" type="number" step="0.01" class="form-control" placeholder="Quantidade" required>
            </div>
            <div class="col-md-2">
                <button type="button" class="btn btn-danger btn-remove-material">X</button>
            </div>
        `;
        container.insertBefore(newRow, document.getElementById('btn-add-material'));
        materialIndex++;
    });
    
    // Remover material
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('btn-remove-material')) {
            const rows = document.querySelectorAll('.material-row');
            if (rows.length > 1) {
                e.target.closest('.material-row').remove();
            }
        }
    });
});
</script>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-success">Salvar</button>
            <a href="<?php echo e(route('ops.index')); ?>" class="btn btn-secondary">Voltar</a>
        </div>
    </form>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\sistema-producao\resources\views/ops/create.blade.php ENDPATH**/ ?>