

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h1 class="mb-4">Ordens de Produção</h1>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <a href="<?php echo e(route('ops.create')); ?>" class="btn btn-primary mb-3">Nova OP</a>

    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>ID</th>
                <th>Número</th>
                <th>Data</th>
                <th>Modelo</th>
                <th>Quantidade</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $ops; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $op): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($op->id); ?></td>
                <td><?php echo e($op->numero_op); ?></td>
                <td><?php echo e($op->data); ?></td>
                <td><?php echo e(optional($op->modelo)->nome); ?></td>
                <td><?php echo e($op->quantidade); ?></td>
                <td>
                    <a href="<?php echo e(route('ops.show', $op)); ?>" class="btn btn-info btn-sm">Ver</a>
                    <a href="<?php echo e(route('ops.edit', $op)); ?>" class="btn btn-warning btn-sm">Editar</a>
                    <form action="<?php echo e(route('ops.destroy', $op)); ?>" method="POST" class="d-inline">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button onclick="return confirm('Tem certeza?')" class="btn btn-danger btn-sm">Excluir</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\sistema-producao\resources\views/ops/index.blade.php ENDPATH**/ ?>