

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h1 class="mb-4">Etapas de Produção</h1>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <a href="<?php echo e(route('etapas.create')); ?>" class="btn btn-primary mb-3">Nova Etapa</a>

    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>ID</th>
                <th>OP</th>
                <th>Oficina</th>
                <th>Etapa</th>
                <th>Status</th>
                <th>Data Início</th>
                <th>Data Conclusão</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $etapas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($e->id); ?></td>
                <td><?php echo e(optional($e->op)->numero_op ?? '-'); ?></td>
                <td><?php echo e(optional($e->oficina)->nome ?? '-'); ?></td>
                <td><?php echo e($e->etapa); ?></td>
                <td><?php echo e($e->status); ?></td>
                <td><?php echo e($e->data_inicio); ?></td>
                <td><?php echo e($e->data_conclusao); ?></td>
                <td>
                    <a href="<?php echo e(route('etapas.show', $e)); ?>" class="btn btn-info btn-sm">Ver</a>
                    <a href="<?php echo e(route('etapas.edit', $e)); ?>" class="btn btn-warning btn-sm">Editar</a>
                    <form action="<?php echo e(route('etapas.destroy', $e)); ?>" method="POST" class="d-inline">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button onclick="return confirm('Tem certeza?')" class="btn btn-danger btn-sm">Excluir</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\sistema-producao\resources\views/etapas/index.blade.php ENDPATH**/ ?>