

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h1 class="mb-4">Editar Material</h1>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('materiais.update', $material->id)); ?>" method="POST" class="card card-body">
    <?php echo csrf_field(); ?>
    <?php echo method_field('PUT'); ?>

        <div class="mb-3">
            <label class="form-label">Nome</label>
            <input type="text" name="nome" value="<?php echo e(old('nome', $material->nome)); ?>" class="form-control" required>
        </div>
        <div class="mb-3">
        <label class="form-label">Categoria</label>
        <select name="categoria" class="form-select">
            <?php $__currentLoopData = ['Tecido','Forro','Zíper','Outro']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($cat); ?>" <?php if($cat == $material->categoria): ?> selected <?php endif; ?>><?php echo e($cat); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Unidade</label>
            <input type="text" name="unidade" value="<?php echo e(old('unidade', $material->unidade)); ?>" class="form-control" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Estoque Atual</label>
            <input type="number" step="0.01" name="estoque_atual" value="<?php echo e(old('estoque_atual', $material->estoque_atual)); ?>" class="form-control">
        </div>

        <div class="mb-3">
            <label class="form-label">Estoque Mínimo</label>
            <input type="number" step="0.01" name="estoque_minimo" value="<?php echo e(old('estoque_minimo', $material->estoque_minimo)); ?>" class="form-control">
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">Atualizar</button>
            <a href="<?php echo e(route('materiais.index')); ?>" class="btn btn-secondary">Voltar</a>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\sistema-producao\resources\views/materiais/edit.blade.php ENDPATH**/ ?>