

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h1 class="mb-4">Oficinas</h1>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <a href="<?php echo e(route('oficinas.create')); ?>" class="btn btn-primary mb-3">Nova Oficina</a>

    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>ID</th>
                <th>Nome</th>
                <th>Responsável</th>
                <th>Tipo</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $oficinas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $o): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($o->id); ?></td>
                <td><?php echo e($o->nome); ?></td>
                <td><?php echo e($o->responsavel); ?></td>
                <td><?php echo e($o->tipo); ?></td>
                <td>
                    <a href="<?php echo e(route('oficinas.show', $o)); ?>" class="btn btn-info btn-sm">Ver</a>
                    <a href="<?php echo e(route('oficinas.edit', $o)); ?>" class="btn btn-warning btn-sm">Editar</a>
                    <form action="<?php echo e(route('oficinas.destroy', $o)); ?>" method="POST" class="d-inline">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button onclick="return confirm('Tem certeza?')" class="btn btn-danger btn-sm">Excluir</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\sistema-producao\resources\views/oficinas/index.blade.php ENDPATH**/ ?>