

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h1 class="mb-4">Editar Ordem de Produção</h1>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('ops.update', $op->id)); ?>" method="POST" class="card card-body">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div class="mb-3">
            <label class="form-label">Número OP</label>
            <input type="text" value="<?php echo e($op->numero_op); ?>" class="form-control" readonly style="background-color: #f8f9fa;">
            <small class="form-text text-muted">
                <i class="fas fa-lock"></i>
                O número da OP não pode ser alterado. Para modificar, edite diretamente no banco de dados.
            </small>
        </div>

        <div class="mb-3">
            <label class="form-label">Data</label>
            <input type="date" name="data" value="<?php echo e(old('data', $op->data)); ?>" class="form-control">
        </div>

        <div class="mb-3">
            <label class="form-label">Modelo</label>
            <select name="modelo_id" class="form-select">
                <option value="">Selecione</option>
                <?php $__currentLoopData = \App\Models\Modelo::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($m->id); ?>" <?php if($m->id == $op->modelo_id): ?> selected <?php endif; ?>><?php echo e($m->nome); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Quantidade</label>
            <input type="number" name="quantidade" value="<?php echo e(old('quantidade', $op->quantidade)); ?>" class="form-control">
        </div>

        <div class="mb-3">
            <label class="form-label">Descrição</label>
            <textarea name="descricao" class="form-control"><?php echo e(old('descricao', $op->descricao)); ?></textarea>
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">Atualizar</button>
            <a href="<?php echo e(route('ops.index')); ?>" class="btn btn-secondary">Voltar</a>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\sistema-producao\resources\views/ops/edit.blade.php ENDPATH**/ ?>