

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h1 class="mb-4">Detalhes da Ordem de Produção</h1>

    <div class="card card-body mb-3">
        <p><strong>Número OP:</strong> <?php echo e($op->numero_op); ?></p>
        <p><strong>Data:</strong> <?php echo e(\Carbon\Carbon::parse($op->data)->format('d/m/Y')); ?></p>
        <p><strong>Modelo:</strong> <?php echo e(optional($op->modelo)->nome ?? '-'); ?></p>
        <p><strong>Quantidade:</strong> <?php echo e($op->quantidade); ?></p>
        <p><strong>Descrição:</strong> <?php echo e($op->descricao); ?></p>
    </div>

    <h4>Materiais Consumidos</h4>
    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>Material</th>
                <th>Categoria</th>
                <th>Quantidade</th>
                <th>Unidade</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $op->consumos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e(optional($c->material)->nome ?? '-'); ?></td>
                    <td><?php echo e($c->categoria); ?></td>
                    <td><?php echo e($c->quantidade); ?></td>
                    <td><?php echo e($c->unidade); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="4" class="text-center">Nenhum consumo registrado.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <a href="<?php echo e(route('ops.index')); ?>" class="btn btn-secondary mt-3">Voltar</a>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\sistema-producao\resources\views/ops/show.blade.php ENDPATH**/ ?>