<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h1 class="mb-4">Dashboard</h1>

    <div class="row g-4 mb-4">
        <div class="col-md-3">
            <div class="card text-white bg-primary">
                <div class="card-body">
                    <h5 class="card-title">Total de OPs</h5>
                    <p class="fs-3"><?php echo e(\App\Models\Op::count()); ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-success">
                <div class="card-body">
                    <h5 class="card-title">OPs Concluídas</h5>
                    <p class="fs-3"><?php echo e(\App\Models\Etapa::where('status','Concluido')->count()); ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-warning">
                <div class="card-body">
                    <h5 class="card-title">Em Andamento</h5>
                    <p class="fs-3"><?php echo e(\App\Models\Etapa::where('status','Em Andamento')->count()); ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-danger">
                <div class="card-body">
                    <h5 class="card-title">Atrasadas</h5>
                    <p class="fs-3"><?php echo e(\App\Models\Etapa::where('status','Pendente')->count()); ?></p>
                </div>
            </div>
        </div>
    </div>

    <form method="GET" class="row g-3 mb-4">
        <div class="col-md-3">
            <label class="form-label">Status</label>
            <select name="status" class="form-select">
                <option value="Todos" <?php echo e(request('status')=='Todos' ? 'selected' : ''); ?>>Todos</option>
                <option value="Pendente" <?php echo e(request('status')=='Pendente' ? 'selected' : ''); ?>>Pendente</option>
                <option value="Em Andamento" <?php echo e(request('status')=='Em Andamento' ? 'selected' : ''); ?>>Em Andamento</option>
                <option value="Concluido" <?php echo e(request('status')=='Concluido' ? 'selected' : ''); ?>>Concluído</option>
            </select>
        </div>
        <div class="col-md-3">
            <label class="form-label">Oficina</label>
            <select name="oficina_id" class="form-select">
                <option value="">Todas</option>
                <?php $__currentLoopData = $oficinas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $oficina): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($oficina->id); ?>" <?php echo e(request('oficina_id')==$oficina->id ? 'selected' : ''); ?>>
                        <?php echo e($oficina->nome); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div class="col-md-3">
            <label class="form-label">Número OP</label>
            <input type="text" name="numero_op" value="<?php echo e(request('numero_op')); ?>" class="form-control">
        </div>
        <div class="col-md-3 d-flex align-items-end">
            <button type="submit" class="btn btn-primary w-100">Filtrar</button>
        </div>
    </form>

    <h2 class="mb-3">Ordens de Produção</h2>

    <div class="table-responsive">
        <table class="table table-bordered">
            <thead class="table-light">
                <tr>
                    <th>OP</th>
                    <th>Etapa</th>
                    <th>Oficina</th>
                    <th>Status</th>
                    <th>Previsão</th>
                    <th>Dias na Etapa</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $etapas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $etapa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $diasNaEtapa = $etapa->data_inicio ? 
                            \Carbon\Carbon::parse($etapa->data_inicio)->diffInDays(now()) : 0;
                        
                        // Lógica de cores baseada na previsão e status
                        $cor = '';
                        if($etapa->status == 'Concluido'){
                            $cor = 'table-success'; // Verde = concluído
                        } elseif($etapa->data_previsao && now()->gt(\Carbon\Carbon::parse($etapa->data_previsao)) && $etapa->status != 'Concluido'){
                            $cor = 'table-danger'; // Vermelho = passou da previsão (atrasado)
                        } else {
                            $cor = ''; // Branco = dentro do prazo
                        }
                    ?>
                    <tr class="<?php echo e($cor); ?>">
                        <td><?php echo e($etapa->op->numero_op ?? '-'); ?></td>
                        <td><?php echo e($etapa->etapa); ?></td>
                        <td><?php echo e($etapa->oficina->nome ?? '-'); ?></td>
                        <td>
                            <?php if($etapa->data_previsao && now()->gt(\Carbon\Carbon::parse($etapa->data_previsao)) && $etapa->status != 'Concluido'): ?>
                                <span class="badge bg-danger">Pendente</span>
                            <?php else: ?>
                                <span class="badge bg-<?php echo e($etapa->status == 'Concluido' ? 'success' : ($etapa->status == 'Em Andamento' ? 'warning' : 'secondary')); ?>">
                                    <?php echo e($etapa->status); ?>

                                </span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($etapa->data_previsao ? \Carbon\Carbon::parse($etapa->data_previsao)->format('d/m/Y') : '-'); ?></td>
                        <td><?php echo e((int) $diasNaEtapa); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <!-- Legenda das cores -->
    <div class="mt-3">
        <h6>Legenda:</h6>
        <div class="d-flex gap-3">
            <span><span class="badge bg-success">Verde</span> = Concluído</span>
            <span><span class="badge bg-danger">Vermelho</span> = Atrasado (passou da previsão)</span>
            <span><span class="badge bg-light text-dark">Branco</span> = Dentro do prazo</span>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\sistema-producao\resources\views/dashboard.blade.php ENDPATH**/ ?>