

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h1 class="mb-4">Editar Etapa</h1>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('etapas.update', $etapa->id)); ?>" method="POST" class="card card-body">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div class="mb-3">
            <label class="form-label">OP</label>
            <select name="op_id" class="form-select" required>
                <option value="">Selecione</option>
                <?php $__currentLoopData = \App\Models\Op::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $o): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($o->id); ?>" <?php if($o->id == $etapa->op_id): ?> selected <?php endif; ?>><?php echo e($o->numero_op); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Oficina</label>
            <select name="oficina_id" class="form-select" required>
                <option value="">Selecione</option>
                <?php $__currentLoopData = \App\Models\Oficina::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($f->id); ?>" <?php if($f->id == $etapa->oficina_id): ?> selected <?php endif; ?>><?php echo e($f->nome); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Etapa</label>
            <select name="etapa" class="form-select" required>
                <?php $__currentLoopData = ['Compra do Tecido','Envio para São Paulo','Corte','Costura','Lavanderia']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($e); ?>" <?php if($e == $etapa->etapa): ?> selected <?php endif; ?>><?php echo e($e); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Status</label>
            <select name="status" class="form-select" required>
                <?php $__currentLoopData = ['Pendente','Em Andamento','Concluido']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($s); ?>" <?php if($s == $etapa->status): ?> selected <?php endif; ?>><?php echo e($s); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Data Início</label>
            <input type="date" name="data_inicio" value="<?php echo e(old('data_inicio', $etapa->data_inicio)); ?>" class="form-control">
        </div>

        <div class="mb-3">
            <label class="form-label">Previsão</label>
            <input type="date" name="data_previsao" value="<?php echo e(old('data_previsao', $etapa->data_previsao)); ?>" class="form-control">
        </div>

        <div class="mb-3">
            <label class="form-label">Data Conclusão</label>
            <input type="date" name="data_conclusao" value="<?php echo e(old('data_conclusao', $etapa->data_conclusao)); ?>" class="form-control">
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">Atualizar</button>
            <a href="<?php echo e(route('etapas.index')); ?>" class="btn btn-secondary">Voltar</a>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\sistema-producao\resources\views/etapas/edit.blade.php ENDPATH**/ ?>