

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h1 class="mb-4">Modelos</h1>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <a href="<?php echo e(route('modelos.create')); ?>" class="btn btn-primary mb-3">Novo Modelo</a>

    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>ID</th>
                <th>Nome</th>
                <th>Tamanho</th>
                <th>Ficha Técnica</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $modelos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($m->id); ?></td>
                <td><?php echo e($m->nome); ?></td>
                <td><?php echo e($m->tamanho); ?></td>
                <td><?php echo e($m->ficha_tecnica); ?></td>
                <td>
                    <a href="<?php echo e(route('modelos.show', $m)); ?>" class="btn btn-info btn-sm">Ver</a>
                    <a href="<?php echo e(route('modelos.edit', $m)); ?>" class="btn btn-warning btn-sm">Editar</a>
                    <form action="<?php echo e(route('modelos.destroy', $m)); ?>" method="POST" class="d-inline">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button onclick="return confirm('Tem certeza?')" class="btn btn-danger btn-sm">Excluir</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\sistema-producao\resources\views/modelos/index.blade.php ENDPATH**/ ?>