<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Laravel')); ?></title>

    <!-- Bootstrap CSS via CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body class="bg-gray-100 text-gray-900">

    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
    <div class="container">
        <a class="navbar-brand fw-bold" href="/">Sistema Produção</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ms-auto">
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('fornecedores.index')); ?>">Fornecedores</a>
                </li>
               
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('oficinas.index')); ?>">Oficinas</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('modelos.index')); ?>">Modelos</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('ops.index')); ?>">OPs</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('etapas.index')); ?>">Etapas</a>
                </li>
                <li>
                    <a class="nav-link" href="<?php echo e(route('materiais.index')); ?>">Materiais</a>
                </li>
                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: inline;">
    <?php echo csrf_field(); ?>
    <button type="submit" class="btn btn-link" style="padding:0; border:none; background:none;">
        Sair
    </button>
</form>

            </ul>
        </div>
    </div>
</nav>


    <main class="p-4">
        <?php echo $__env->yieldContent('content'); ?>
    </main>
<script src="https://cdn.jsdelivr.net/npm/vue@2.6.14"></script>
<script>
if (document.getElementById('materiais-repeater')) {
    new Vue({
        el: '#materiais-repeater',
        data: {
            materiais: <?php echo json_encode(session('materiais_old', [[]])); ?>

        },
        methods: {
            addItem() {
                this.materiais.push({});
            },
            removeItem(index) {
                this.materiais.splice(index, 1);
            }
        }
    });
}
</script>

<!-- Bootstrap Bundle JS via CDN -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
<?php /**PATH C:\laragon\www\sistema-producao\resources\views/layouts/app.blade.php ENDPATH**/ ?>