

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h1 class="mb-4">Detalhes do Material</h1>

    <div class="card card-body mb-4">
        <div class="row">
            <div class="col-md-6">
                <p><strong>Nome:</strong> <?php echo e($material->nome); ?></p>
                <p><strong>Categoria:</strong> <?php echo e($material->categoria ?? 'N/A'); ?></p>
                <p><strong>Unidade:</strong> <?php echo e($material->unidade); ?></p>
            </div>
            <div class="col-md-6">
                <p><strong>Estoque Atual:</strong> 
                    <span class="badge bg-<?php echo e($material->estoque_atual > 0 ? 'success' : 'danger'); ?>">
                        <?php echo e($material->estoque_atual); ?>

                    </span>
                </p>
                <p><strong>Estoque Mínimo:</strong> <?php echo e($material->estoque_minimo); ?></p>
                <p><strong>Data de Cadastro:</strong> <?php echo e($material->created_at->format('d/m/Y H:i')); ?></p>
            </div>
        </div>
    </div>

    <!-- Histórico Completo -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Histórico Completo</h5>
        </div>
        <div class="card-body">
            <?php
                $historico = $material->getHistoricoCompleto();
            ?>

            <?php if($historico->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Data/Hora</th>
                                <th>Tipo</th>
                                <th>Quantidade</th>
                                <th>Motivo</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $historico; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(\Carbon\Carbon::parse($item['data'])->format('d/m/Y H:i')); ?></td>
                                    <td>
                                        <?php if($item['categoria'] == 'movimentacao'): ?>
                                            <span class="badge bg-<?php echo e($item['tipo'] == 'Entrada' ? 'success' : 'warning'); ?>">
                                                <?php echo e($item['tipo']); ?>

                                            </span>
                                        <?php else: ?>
                                            <span class="badge bg-danger"><?php echo e($item['tipo']); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($item['quantidade']); ?></td>
                                    <td><?php echo e($item['motivo']); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="alert alert-info">
                    <i class="fas fa-info-circle"></i>
                    Nenhuma movimentação registrada para este material.
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Resumo de Movimentações -->
    <div class="row mt-4">
        <div class="col-md-4">
            <div class="card text-white bg-success">
                <div class="card-body">
                    <h6 class="card-title">Total de Entradas</h6>
                    <p class="fs-5"><?php echo e($historico->where('categoria', 'movimentacao')->where('tipo', 'Entrada')->sum('quantidade')); ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-white bg-danger">
                <div class="card-body">
                    <h6 class="card-title">Total de Saídas</h6>
                    <p class="fs-5"><?php echo e($historico->where('categoria', 'consumo')->sum('quantidade') + $historico->where('categoria', 'movimentacao')->where('tipo', 'Saída')->sum('quantidade')); ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-white bg-info">
                <div class="card-body">
                    <h6 class="card-title">Consumos por OP</h6>
                    <p class="fs-5"><?php echo e($historico->where('categoria', 'consumo')->count()); ?></p>
                </div>
            </div>
        </div>
    </div>

    <div class="mt-4">
        <a href="<?php echo e(route('materiais.index')); ?>" class="btn btn-secondary">Voltar</a>
        <a href="<?php echo e(route('materiais.edit', $material->id)); ?>" class="btn btn-primary">Editar</a>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\sistema-producao\resources\views/materiais/show.blade.php ENDPATH**/ ?>