

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h1 class="mb-4">Detalhes da Etapa</h1>

    <div class="card card-body mb-4">
        <div class="row">
            <div class="col-md-6">
                <p><strong>OP:</strong> <?php echo e(optional($etapa->op)->numero_op ?? '-'); ?></p>
                <p><strong>Oficina:</strong> <?php echo e(optional($etapa->oficina)->nome ?? '-'); ?></p>
                <p><strong>Etapa:</strong> <?php echo e($etapa->etapa); ?></p>
                <p><strong>Status:</strong> 
                    <?php
                        $statusAtual = $etapa->status;
                        if($etapa->data_previsao && now()->gt(\Carbon\Carbon::parse($etapa->data_previsao)) && $etapa->status != 'Concluido'){
                            $statusAtual = 'Pendente';
                        }
                    ?>
                    <span class="badge bg-<?php echo e($statusAtual == 'Concluido' ? 'success' : ($statusAtual == 'Pendente' ? 'danger' : 'warning')); ?>">
                        <?php echo e($statusAtual); ?>

                    </span>
                </p>
            </div>
            <div class="col-md-6">
                <p><strong>Data Início:</strong> <?php echo e($etapa->data_inicio ? \Carbon\Carbon::parse($etapa->data_inicio)->format('d/m/Y') : '-'); ?></p>
                <p><strong>Previsão:</strong> <?php echo e($etapa->data_previsao ? \Carbon\Carbon::parse($etapa->data_previsao)->format('d/m/Y') : '-'); ?></p>
                <p><strong>Data Conclusão:</strong> <?php echo e($etapa->data_conclusao ? \Carbon\Carbon::parse($etapa->data_conclusao)->format('d/m/Y') : '-'); ?></p>
                <?php if($etapa->data_inicio): ?>
                    <p><strong>Dias na Etapa:</strong> <?php echo e((int) \Carbon\Carbon::parse($etapa->data_inicio)->diffInDays(now())); ?></p>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Histórico Detalhado de Alterações -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="fas fa-history"></i>
                Histórico Detalhado de Alterações
            </h5>
        </div>
        <div class="card-body">
            <?php if($etapa->logs->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Data/Hora</th>
                                <th>Usuário</th>
                                <th>Campo Alterado</th>
                                <th>Valor Anterior</th>
                                <th>Valor Novo</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $etapa->logs->sortByDesc('data'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(\Carbon\Carbon::parse($log->data)->format('d/m/Y H:i')); ?></td>
                                    <td>
                                        <span class="badge bg-secondary"><?php echo e($log->usuario); ?></span>
                                    </td>
                                    <td>
                                        <strong><?php echo e($log->campo_alterado); ?></strong>
                                    </td>
                                    <td>
                                        <?php if($log->valor_anterior): ?>
                                            <span class="text-muted"><?php echo e($log->valor_anterior); ?></span>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($log->valor_novo): ?>
                                            <span class="text-success"><strong><?php echo e($log->valor_novo); ?></strong></span>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="alert alert-info">
                    <i class="fas fa-info-circle"></i>
                    Nenhuma alteração registrada para esta etapa.
                </div>
            <?php endif; ?>
        </div>
    </div>

    <div class="mt-4">
        <a href="<?php echo e(route('etapas.index')); ?>" class="btn btn-secondary">Voltar</a>
        <a href="<?php echo e(route('etapas.edit', $etapa->id)); ?>" class="btn btn-primary">Editar</a>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\sistema-producao\resources\views/etapas/show.blade.php ENDPATH**/ ?>